/*
Versionshistorie

V1: Erstversion

V2: Sporadische Absteller ohne Vorwarnung. Ursache: Timeout beim pulsein im Unterprogramm
    stop_check (m.E. ein Sender-Problem). Abfrage nun so geändert, dass ein Timeout einfach 
    übersprungen wird und nicht mehr als manuelles Abschaltsignal gewertet wird.

    Ein Neustart des Arduino wird nun auf der Jetibox angezeigt, um ggf. einen Neustart
    durch kurze Stromunterbrechung erkennen zu können.
*/

// #define eeprom_schreiben // nach dem ersten Beschreiben eines Arduino ggf. auskommentieren

#include <Servo.h>    // Bibliothek für Servoansteuerung
#include <EEPROM.h>   // Bibliothek für EEPROM Nutzung
#include "JetiExProtocol.h"  // Bibliothek für Jeti-Protokoll (Quelle = Jetiforum)

JetiExProtocol jetiEx;

enum
{
  ID_RPM = 1,
  ID_ZEIT,
};
JETISENSOR_CONST sensors[] PROGMEM =
{
  // id            name          unit         data type             precision 0->0, 1->0.0, 2->0.00
  {ID_RPM,       "Drehzahl",     "rpm ",      JetiSensor::TYPE_14b, 0 },
  {ID_ZEIT,      "Zeit",         "sek ",      JetiSensor::TYPE_14b, 0 },        
  0 // end of array
};

Servo sig_regler;     // Einrichten der Servoinstanz

#include "parameter.h"; // Definition der steuernden Programmparameter

// Pin-Belegungen und -Nutzung
int pin_rpm = 2;      // Interrupt 0 zur rpm-Messung
int pin_empf = 3;     // Eingabesignal vom RC-Empfänger
int pin_regler = 4;   // Ausgabesignal für Regler
int pin_led = 13;     // LED für Zustandsanzeige

int sig_empf;         // Empfängersignal für Motor ein/aus
int led_status;       // für Abfrage LED an oder aus

// Programmstati

const byte p_warten = 0;  // Warten weil Servosignal bei Progstart auf Motor ein
const byte p_bereit = 1;  // Bereitschaft über LED anzeigen
const byte p_anlauf = 2;  // Motor Anlauf gemäß Parameter
const byte p_lauf = 3;    // Motorlauf und Laufzeitcheck
const byte p_stop = 4;    // Motor abstellen und da capo
byte p_status;            // Programmstatus für Steuerungsloop

// Fehler Flags
boolean f_ueberlast = false;  // Überlast Flag, Drehzahl kann nicht gehalten werden
boolean f_notstop = false;    // Notstop Flag, Drehzahl wurde abgewürgt
boolean f_neustart = true;
boolean f_timeout = false;

// Sonstige Variablen
volatile int rpm_count;   // Interruptzähler für Drehzahlmessung
float rpm;                // Ergebnis Drehzalmessung
float rpm_alt;            // vorletzte gemessene Drehzahl
float rpm_diff;           // Drehzahlabweichung vom Soll
float rpm_diffabs;        // w.o. als absolute Zahl
unsigned long start_rpm;  // Zeitstempel für Beginn Drehzahlmessung
unsigned long start_lauf; // Zeitstempel für Beginn Motorlauf
unsigned long zeit_lauf;  // Zeitstempel für aktuelle Laufzeit
unsigned long zeit_anlauf;  //Anlaufzeit ohne rpm-Überwachung
long zeit_dauer;          // aktuelle Motorlaufzeit
int sek_lauf;             // aktuelle Motorlaufzeit in Sekunden
int sek_rest;             // Restlaufzeit in Sekunden
float dauer_rpm;          // Zeitdauer für Drehzahlmessung
float rpm_faktor;         // Hilfsfeld
int aktsig_regler;        // aktuelles Reglersignal
int regler_diff;          // nächste Erhöhung oder Verringerung Reglersignal
int sigmax_count;         // Überlastzähler

int jeti_rpm;             // rpm für EX Protokoll
int jb_level;             // Level für Jetibox Ein-/Ausgabe
const int jb_maxlevel=maxpar+2;   // maximale Anzahl Jetibox Bildchen
static char zeile[17];    // für Aufbereitung Sensorwerte EX-Protokoll
char hife [17];           // Hilfsfeld für Aufbereitung zeil
const unsigned long timeout_pulsein = 50000;



// Einmalaufgaben zu Anfang <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void setup() {
  pinMode (pin_rpm, INPUT);
  pinMode (pin_empf, INPUT);
  sig_regler.attach(pin_regler, par[motor_aus], par[motor_max]);
  sig_regler.writeMicroseconds( par[motor_aus]);
  attachInterrupt(0,rpm_IR,CHANGE);   // Interrupt 1 für rpm-Messung
  
  #ifdef eeprom_schreiben   
    schreiben_eeprom();   // initiales Schreiben bei neuem Board
  #endif

  lesen_eeprom();   // Parameterstände aus EEPROM lesen
  
  jetiEx.Start("FFS4", sensors );   // EX-Sensor starten
  jetiEx.Start( NULL, NULL, JetiExProtocol::SERIAL2 );
  jb_level = 0;
  jetibox_ausgabe();
  jetiEx.DoJetiSend();    // und EX-Protokoll senden  
  p_status = p_warten;    // los geh's mit warten Empfängersignal Motor aus
  jb_level = 1;
} //end setup


// Steuerschleife <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void loop() {
  switch (p_status) {
    case p_warten:    
      sub_warten();   // Warten bis Empfängersignal auf Motor aus 
      break;
    case p_bereit:
      sub_bereit ();  // Bereitschaft über LED anzeigen
      break;
    case p_anlauf:
      sub_anlauf();   // Motoranlauf entsprechend Parameter
      break;
    case p_lauf:      
      sub_lauf ();    // Motorlauf und Zeitcheck
      break;
    case p_stop:      
      sub_stop();     // Motor abstellen und Status auf da capo
      break;
    default:
      p_status = p_stop;  // Wenn das erreicht wird liegt ein Programmfehler vor
  } // end switch
  jeti_rpm = rpm;     // rpm für Ausgabe konvertieren
  jetiEx.SetSensorValue(ID_RPM,jeti_rpm);   // Sensorwert rpm bereitstellen
  jetiEx.SetSensorValue(ID_ZEIT,sek_lauf);  // dto für Laufzeit
  jetibox_ausgabe();      // Werte auf Jetibox bereitstellen
  jetiEx.DoJetiSend();    // und EX-Protokoll senden 
} //end loop

// Warten (weil Schalter zu Anfang nicht auf Stop) <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_warten() {
  sig_empf = pulseIn(pin_empf,HIGH,timeout_pulsein);
  jb_level = 2;   // Ausgabelevel auf Ausgabe Fehlerstati
  if (sig_empf >  par[motor_aus]) {   // Signal für Motor noch nicht zurückgesetzt
    if (f_ueberlast == true || f_notstop == true || f_neustart == true) {
        sub_dit();      // Morsecode für "F" wie Fehler ausgeben
        sub_dit();
        sub_dah();
        sub_dit();
      }
      else
      { 
        sub_dit();
        sub_dah();
      } // end if
    delay_jb (500);     // und wieder von vorn
  }
  else
  {
    sigmax_count = 0;     // Überlastzähler rücksetzen
    if (f_ueberlast = true) EEPROM.get (laufzeit, par[laufzeit]);  // Laufzeit neu aus EEPROM lesen
    f_ueberlast = false;  // Überlast Flag zurücksetzen
    f_notstop = false;    // Notstop Flag zurücksetzen
  p_status = p_bereit;    // Warten beenden
  } // end if
} // end sub_warten

void sub_dit() {
  jetibox_ausgabe();
  jetiEx.DoJetiSend();   
  digitalWrite(pin_led,HIGH);
  delay_jb (200);
  digitalWrite(pin_led,LOW);
  delay_jb (200);
} // end sub_dit

void sub_dah() {   
  digitalWrite(pin_led,HIGH);
  delay_jb (500);  
  digitalWrite(pin_led,LOW);
  delay_jb(200);  
} // end sub_dah

void delay_jb(int msek){
  for (int i=0; i < msek; i=i+10) {
    jetibox_eingabe();
    jetibox_ausgabe();
    jetiEx.DoJetiSend();
    delay (10);         
  }  // next for
}   // end sub delay_jb

// Bereit <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_bereit() {
  sig_empf = pulseIn(pin_empf,HIGH,timeout_pulsein);
  if (sig_empf <=  par[motor_aus]+10) { // + 10 wegen Unschärfe Empfängersignal Servotester
    digitalWrite(pin_led, !(digitalRead(pin_led)));  // LED toggeln
    delay_jb (500);
  }
  else 
  {
    digitalWrite(pin_led,LOW);
    p_status = p_anlauf;    // Programmstatus auf Motor-Anlauf
    f_neustart = false;
    f_timeout = false;
    jb_level = 1;           // Ausgabelevel für rpm und Zeit
  }
} // end sub_bereit


// Anlauf <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_anlauf() {
  for(int i=0; i<10; i++) {   // schnelles Blinken für: gleich gehts los
    digitalWrite(pin_led,LOW);
    delay_jb (150);
    digitalWrite(pin_led,HIGH);
    delay_jb (150);
  } // end for
  start_lauf = millis();      // Zeitstempel für Zeitmessung
  digitalWrite(pin_led,LOW);    // Während normalem Lauf bleibt LED aus
  for(int i= par[motor_anlauf_anf]; i< par[motor_anlauf_end]+1; i=i+15) {
    stop_check();   // prüfen auf Stop vom Sender
    if (p_status == p_stop) return;  // und ggf. zurück zur Steuerschleife
    sig_regler.writeMicroseconds(i); // Reglersignal ausgeben   
    aktsig_regler=i;    // aktuelles Reglersignal merken
    delay_jb(50);                      
    zeit_anlauf = millis() - start_lauf;  // Anlaufzeit berechnen
    if(zeit_anlauf >  par[anlaufzeit]) {    // überwachungsfreie Zeit abgelaufen?
      rpm_check();    // wenn ja, dann Drehzahl prüfen
      if(rpm < 3000 && par[rpm_status] > 0) {   // Wenn Drehzahl < 3000 und Prüfung gefordert
        f_notstop = true;   // dann Motor ausschalten
        p_status = p_stop;
        return;
      } // end if
    } // end if
    zeit_lauf = millis();   // aktuelle Zeit
    zeit_dauer = zeit_lauf - start_lauf;    // bisherige Laufzeit in millis
    sek_lauf = zeit_dauer / 1000;   // bisherige Laufzeit in Sekunden
    jb_level = 1;   // Ausgabe auf rpm Bild     
    jetibox_ausgabe();
    jetiEx.DoJetiSend();
  } // end for 
  if(par[rpm_status] < 2) {   // keine aktive rpm-Regelung gefordert
    aktsig_regler = par[motor_max];   // fixes Signal für Regler aus Parametern 
    sig_regler.writeMicroseconds(aktsig_regler);    // Reglersignal ausgeben
  } // end if
  p_status = p_lauf;    // Anlauf beendet
} // end sub_anlauf


// Lauf <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_lauf() {
  sub_regeln();   // Drehzahl regeln
  stop_check();   // manuellen Stop prüfen
  zeit_lauf = millis();   // aktuelle zeit
  zeit_dauer = zeit_lauf - start_lauf;    //bisherige Laufzeit
  sek_lauf = zeit_dauer / 1000;   //bisheriege Laufzeit in Sekunden
  if (f_ueberlast == false) {  // noch keine Überlast aufgetreten
    if (sigmax_count > 10) {    // mehr als 10 vergebliche Regelungsversuche
    par[laufzeit] = sek_lauf + 10;    // Laufzeit auf jetzt + 10 setzen
    f_ueberlast = true;    // Fehler Flag setzen
    } // end if  
  } // end if
  if (sek_lauf >=  par[laufzeit] -10) digitalWrite(pin_led,HIGH);   // 10 Sekunden vor Schluss LED an
  if (sek_lauf >=  par[laufzeit]) p_status = p_stop;
} // end sub_lauf


// Stop <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_stop () {
  sig_regler.writeMicroseconds( par[motor_aus]);  // Motor abstellen
  digitalWrite(pin_led,LOW);    // LED ausschalten
  rpm = 0;    // rpm sofort auf 0
  p_status = p_warten;  // neuer Programmstatus = warten   
} // end sub_stop


// Stop Check <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void stop_check(){
  sig_empf = pulseIn(pin_empf,HIGH,timeout_pulsein);  // Empfängersignal prüfen
  if (sig_empf == 0) f_timeout = true;
  if (sig_empf <=  par[motor_aus] && sig_empf > 0) {    // manuell ausgeschaltet?
    p_status = p_stop;
    sig_regler.writeMicroseconds( par[motor_aus]);    // Motor ausschalten    
  } // end if
}  //end stop_check


// Motor regeln <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void sub_regeln(){
  rpm_check();    // Drehzahl messen
  if (rpm < 3000 && par[rpm_status] > 0) {    // Motor blockiert?
    p_status = p_stop;    // dann Notsopp und
    f_notstop = true;   // Notstop Flag setzen
  }
  if (par[rpm_status] < 2) return;    // zurück, wenn keine Regelung gefordert
  rpm_diff =  par[sollrpm] - rpm;   // = Abweichung von Soll rpm
  rpm_diffabs = abs(rpm_diff);    // ohne Vorzeichen
  regler_diff = rpm_diffabs/40;   // Änderung Reglersignal berechnen
  if (rpm_diff < -10) aktsig_regler = aktsig_regler - regler_diff;  // neues Reglersignal berechnen
  if (rpm_diff > 10) aktsig_regler = aktsig_regler + regler_diff;   // dto
  if (aktsig_regler >  par[motor_max]) {  // größeres als festgelegtes Signal erforderlich?
    aktsig_regler =  par[motor_max];    // Signal nicht mehr vergrößern   
    sigmax_count++;   // Überlastzähler erhöhen
  } // end if
  sig_regler.writeMicroseconds(aktsig_regler); // neues Reglersignal ausgeben
} // end sub_regeln


// rpm_check <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void rpm_check () {
  if (par[rpm_status]==0) return;   // wenn keine Messung gefordert, dann Rücksprung
  start_rpm = millis();   // Zeitstempel für Start rpm-Messung
  rpm_count = 0;    // Interruptzähler auf 0
  delay ( par[messzeit]);   // Messzeit abwarten
  dauer_rpm = millis() - start_rpm;   // exakte Messdauer
  rpm_faktor = 1000 / dauer_rpm;
  rpm = rpm_count * rpm_faktor; // = Impulse pro Sekunde
  rpm = rpm * 60;               // = Impulse pro Minute
  rpm = rpm / ( par[pole] + 2); // = Drehzahl 
} // end rpm_check


// rpm Interrupt <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void rpm_IR() {
  rpm_count ++;
} // end rpm_IR


// Jebibox Eingabe <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void jetibox_eingabe() {
  uint8_t in_key = jetiEx.GetJetiboxKey();
  switch (in_key) {
    case 0: 
      return;
      break;  // erforderlich???
    case 0xb0:    // = runter
      ++jb_level;
      if (jb_level>jb_maxlevel) jb_level = 3;  // Parameter da capo
      delay (50); // Taster entprellen   
      break;
    case 0xd0:    // = rauf
      --jb_level;
      if (jb_level < 0) jb_level = jb_maxlevel;
      delay (50); // Taster entprellen
      break;
    case 0xe0:    // = rechts
      jetibox_wert(1);
      break;
    case 0x70:    // = links
      jetibox_wert(-1);
      break;
    default:
      ;   // Rest gibt es nicht 
  } // end switch
} // end jetibox_eingabe

// Jetibox Ausgabe <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void jetibox_ausgabe() {
  int i;
  int i2;
  switch (jb_level) {
    case 0:
      jetiEx.SetJetiboxText( JetiExProtocol::LINE1, "FFS4" );
      jetiEx.SetJetiboxText( JetiExProtocol::LINE2, "HE FW V1" );
      break;    
    case 1:
      dtostrf(rpm,5,0,hife);
      sprintf(zeile, "Drehz. %s rpm", hife);
      jetiEx.SetJetiboxText(JetiExProtocol::LINE1,zeile);
      sek_rest =  par[laufzeit] - sek_lauf;
      sprintf(zeile, "Zeit:    %3i sek", sek_rest);
      jetiEx.SetJetiboxText(JetiExProtocol::LINE2,zeile);      
      break;
    case 2:
      if (f_neustart == true) {
        sprintf (zeile, "Neustart erfolgt %li ");
      }
      else {
        sprintf (zeile, "Ueberlast: %1i ", f_ueberlast);      
      }
      jetiEx.SetJetiboxText(JetiExProtocol::LINE1,zeile);
      if (f_timeout == true) {
        sprintf (zeile, "Timeout erfolgt %li ");
      }
      else {
        sprintf (zeile, "Notstopp: %1i ", f_notstop);       
      }
      jetiEx.SetJetiboxText(JetiExProtocol::LINE2,zeile);
      break;
    case 3 ... jb_maxlevel:   // 3 bis 12
      i = jb_level - 3;      // i auf 0 = erster Parameter
      jetiEx.SetJetiboxText( JetiExProtocol::LINE1,text[i] );
      String spf_par = String("< " + String(par[i],DEC) + " " + einheit[i] + " >");
      for (i2=0; i2<16; i2++) {
        zeile[i2] = spf_par[i2];
        zeile[i2+1] = '\0';
      } // end for
      jetiEx.SetJetiboxText(JetiExProtocol::LINE2,zeile);
      break;
    default:  
      ; // mehr gibt's nicht 
    }  // end switch
} // end jetibox_ausgabe

// Jetibox Wert ändern <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void jetibox_wert(int faktor) {
  int i;
  switch (jb_level) {
    case 3 ... jb_maxlevel: 
      i = jb_level - 3;       // i auf 0 = erster Parameter
      par[i] =  par[i] + (faktor * schritt[i]);
      if ( par[i] < minwert[i] )  par[i] = minwert[i];
      if ( par[i] > maxwert[i] )  par[i] = maxwert[i];
      EEPROM.put(i * 2,  par[i]);
      break;
    default:
      ; // nix tun
  } // end switch
} // end jetibox_plus
