// steuernde Parameter

enum {
laufzeit = 0,
sollrpm,
motor_aus,
motor_max,
motor_anlauf_anf,
motor_anlauf_end,
anlaufzeit,
pole,
messzeit,
rpm_status,   
maxpar,  
};
int par[] = {
  15,     // laufzeit
  5000,   // sollrpm
  1100,   // motor_aus
  1900,   // motor_max
  1240,   // motor_anlauf_anf
  1300,   // motor_anlauf_end
  1000,   // anlaufzeit
  12,     // pole
  100,    // messzeit
  2,      // rpm_regelung
};

// rpm_regelung:   0 = keine Messung, fixes Signal (kein Notstopp)
//                 1 = Messung, fixes Signal (Notstop)
//                 2 = Messung, Regelung (Notstopp, Überlast)

int minwert[] = {15,4000,1000,1000,1000,1000,100,2,10,0,};
int maxwert[] = {900,20000,2000,2000,2000,2000,2000,36,500,2,};
int schritt[] = {5,50,10,10,10,10,10,2,5,1,};

char* einheit[] ={"sek","rpm","usek","usek","usek","usek","usek"," ","usek"," ",};
char* text [] = {
  "Laufzeit:",
  "Drehzahl:",
  "Motor min:",
  "Motor max:",
  "Anlauf anf:",
  "Anlauf end:",
  "Anlaufzeit:",
  "Pole:",
  "Messzeit:",
  "rpm Regelung:" 
};

// Initiales Schreiben des EEPROMS gesteuert über #define <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void schreiben_eeprom() { 
  for (int i=0; i<maxpar; i++) {
    EEPROM.put (i*2, par[i]);
  } // end for
} // end schreiben_eeprom

// Lesen des EEPROMs bei Programmstart <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
void lesen_eeprom() {
  for(int i=0; i<maxpar; i++){
    EEPROM.get (i*2, par[i]);
  } //end for
} // end_lesen_eeprom
