local appName="LED-Control"
local ctrlIdx		--Index Lua Control
local counter		--aktueller Signalschrit
local signal		--aktuelles Signal
local sLED			--Schalterzustand LED-Schalter
local sLED_alt		--letzter Schalterzustand LED-Schalter
local sSEQ			--Schalterzustand Sequenzer Schalter
local sigSEQ		--aktuelles Signal des Sequenzers
local automat = 0	--Sequenzer inaktiv, aktiv = 1
local maxcount		--Anzahl der Lichtsequenzen
local offset		--Versatz fr LED-Signal (wegen MUDLED-Modul)
local sigoffset		--Signallnge Offset
local step			--Schrittweite LED-Signal
local switchLED		--LED-Schalter
local switchSEQ		--Sequenzer Schalter
local sOSEQ			--Sequenzer Outputsignal
local channelSEQ	--Sequenzer Kanal
local EndSEQ		--Lichtsequenz nach Abschalten des Sequenzers

--------------------------------------------------------------------
--Anfangswerte setzen-
--------------------------------------------------------------------

local function dacapo()
	step = 2/maxcount						--Schrittweite zur nchsten Lichtsequenz
	offset = system.pLoad("offset", 10)		--Start Offset einlesen
	EndSEQ = system.pLoad("EndSEQ",1)		--gewnschte Endesequenz einlesen
	sigoffset = offset/100					--Signallnge Offset berechnen
	signal = -1 + sigoffset					--Signallnge fr Ausgabe Offset berechnen
	system.setControl(1,signal,0,0)			--Signal ausgeben
	counter = 1								--Lichtsequenzzhler auf 1
	signal = signal + step					--Signallnge fr nchste ausgabe
end

--------------------------------------------------------------------
-- Bearbeitungsschleife
--------------------------------------------------------------------

local function loop()
	sLED = system.getInputsVal(switchLED) 			--Schalterstatus LED-schalter abrufen
	if sLED ~= sLED_alt then						--Schalterstatus gendert?
		if (sLED ~= -1) and (automat == 0) then	--Schalter auf -1 und Sequenzer aus?
			system.playNumber(counter,0)			--Sprachausgabe Lichtsequenznummer
		end
		sLED_alt = sLED								--Schalterstatus ndern
		if (sLED >= 0) then						--Schalter nicht auf aus?
			system.setControl(1,signal,0,0)			--Lichtsequenzsignallnge ausgeben
			if (counter == maxcount) then			--max. Lichtsequenznummer erreicht?
				counter = 1							--dann von vorne, d.h. nchste = 1
				signal = -1 + step + sigoffset		--Singnal wieder auf Anfang + Offset
				else
				counter = counter +1				-- = nchste Lichtsequenznummer
				signal = signal + step				-- = nchste Signallnge
				if signal > 1 then					--Signal > 100 %
					signal = 1						--Signal Maximum = 100 %
				end
			end
		else										--LED Schalter auf aus
		counter = 1									--Lichtsequenznummer zurcksetzen
		signal = - 1 + sigoffset					--Signallnge zurcksetzen
		system.setControl(1,signal,0,0)				--Signal ausgeben
		signal = signal + step						--Signallnge fr nchste Ausgabe
		end
	end
	sSEQ = system.getInputsVal(switchSEQ)			--Schalterstatus Sequenzer-Schalter einlesen
	--print (sSEQ)
	if (sSEQ == 1) then							--Seq-Schalter = ein?
		automat = 1									--Status = Sequenzer luft
		sigSEQ = system.getInputs(sOSEQ)			--Sequenzer Signal einlesen
		--print (so6)
		system.setControl(1,sigSEQ,0,0)				--Signal LED mit Signal Seq berschreiben.
	end
	if (sSEQ == - 1) and (automat == 1) then		--Seq. Schalter = aus und Status = Seq. luft?
		automat = 0									--Status Seq. = aus
		counter = EndSEQ + 1							--Lichtsequenzzhler zurcksetzen
		signal = - 1 + sigoffset + EndSEQ * step	--Signal fr LED auf gewnschte Lichtsequenz
		system.setControl(1,signal,0,0)				--Signal auf LED Kanal ausgeben
		signal = signal + step						-- = Signallnge fr nchste Ausgabe
		--print (counter)
	end
end

---------------------------------------------------------
-- Funktionenen fr nderungen im Einstellmen
--
-- Es wird jeweils der aktuelle Wert bernommen und in
-- die Modelldatei weggeschrieben. Anschlieend werden
-- die Anfangswerte neu gesetzt, um die nderung jeweils
-- aktuell zu bernehmen.
---------------------------------------------------------

local function maxcountChanged(value)
	maxcount=value
	system.pSave("maxcount",value)
	dacapo()
end

local function offsetChanged(value)
	offset=value
	system.pSave("offset",value)
	dacapo()
end

local function switchLEDChanged(value)
	switchLED=value
	system.pSave("switchLED",value)
end


local function switchSEQChanged(value)
	switchSEQ=value
	system.pSave("switchSEQ",value)
end

local function channelSEQChanged(value)
	channelSEQ=value
	system.pSave("channelSEQ",value)
end

local function EndSEQChanged(value)
	EndSEQ=value
	system.pSave("EndSEQ",value)
end
------------------------------------------------------------
-- Einstellmen
------------------------------------------------------------

local function initForm(subform)
	form.addRow(2)
	form.addLabel({label="maxcount"})
	form.addIntbox(maxcount,3,10,4,0,1,maxcountChanged) --Zahlenbox: min=3,max=10,std=4,nachkomma=0,schrittweite=1
	form.addRow(2)
	form.addLabel({label="offset"})
	form.addIntbox(offset,0,20,10,0,1,offsetChanged)	--Zahlenbox: min=0,max=20,std=10,nachkomma=0,schrittweite=1
	form.addRow(2)
	form.addLabel({label="SwitchLED"})
	form.addInputbox(switchLED,true,switchLEDChanged)	--Schalterbox: proportional
	form.addRow(2)
	form.addLabel({label="SwitchSEQ"})
	form.addInputbox(switchSEQ,true,switchSEQChanged)	--Schalterbox: proportional
	form.addRow(2)
	form.addLabel({label="ChannelSEQ"})
	form.addIntbox(channelSEQ,1,14,6,0,1,channelSEQChanged)	--Zahlenbox: min=1,max=14,std=6,nachkomma=0,schrittweite=1
	form.addRow(2)
	form.addLabel({label="EndSEQ"})
	form.addIntbox(EndSEQ,0,10,1,0,1,EndSEQChanged)	--Zahlenbox: min=0,max=10,std=1,nachkomma=0,schrittweite=1

end

--------------------------------------------------------------
-- Initialisierungsfunktion
--------------------------------------------------------------
local function init()
	system.registerForm(1,MENU_MAIN,appName,initForm)	--Eingabemaske fr Parameter einrichten
	maxcount = system.pLoad("maxcount",4)				--bisherige Einstellung fr maxcount abholen
	switchLED = system.pLoad("switchLED")				--bisherige Einstellung LED-Schalter abholen
	switchSEQ = system.pLoad("switchSEQ")				--bisherige Einstellung Seq-Schalter abholen
	EndSEQ = system.pLoad("EndSEQ",1)					--bisherige Einstellung Lichtsequenz bei Abschalten Sequenzer abholen
	--print (switchLED, switchSEQ, EndSeq)
	channelSEQ = system.pLoad("channelSEQ",6)			--bisherige Einstellung Seq-Kanal abholen
	sOSEQ = "O"..channelSEQ								--Signal Sequenzerkanal
	--print (sOSEQ)
	ctrlIdx = system.registerControl(1, "Mudled Ctrl","C01")	--Geber fr Ausgabe definieren
	sLED_alt = system.getInputsVal(swichtLED)			--aktueller Stand LED-Schalter = alter Stand
	dacapo()											--Anfangswerte festlegen
end

---------------------------------------------------------------
-- und ab zum API
---------------------------------------------------------------
return { init=init, loop=loop, author="Hermann Eichner", version="12",name=appName}
