/* 
Das Programm ermöglicht eine Kanalerweiterung an einem Empfängerausgang,
der ein PPM Summensignal (negativ) ausgibt. Es werden bis zu 4 Servos bedient. 
Die Zuordnung, welches Servo durch welchen Kanal bedient werden soll, können 
über die Variablen kanal_servo1 bis kanal_servo6 frei zugeordnet werden.

Versionshistorie

V1: Erstversion mit dem o.g. Funktionsumfang für 4 Servos

V2: Erweiterung auf 6 Servos

*/


#include <Servo.h>    // Bibliothek für Servoansteuerung

volatile int su_tab[16], l_su_tab[16];  //Tabellen Summensignalwerte
volatile unsigned long zeit, l_zeit, delta; //Variablen für Berechnung Signallängen
volatile int ind; // Index für Tabelle Summensignalwerte
int sig_diff;
int sig_nixtun = 5;

// Festlegung Servopins
int pin_servo1 = 3;
int pin_servo2 = 4;
int pin_servo3 = 5;
int pin_servo4 = 6;
int pin_servo5 = 7;
int pin_servo6 = 9;

// Kanalzuordnungen für Servos
int kanal_servo1 = 5;
int kanal_servo2 = 4;
int kanal_servo3 = 3;
int kanal_servo4 = 1;
int kanal_servo5 = 2;
int kanal_servo6 = 8;


// Servoinstanzen einrichten
Servo sig_servo1;
Servo sig_servo2;
Servo sig_servo3;
Servo sig_servo4;
Servo sig_servo5;
Servo sig_servo6;

// Einmalige Anfangsaufgaben
void setup() {
  // Interrupt 0 für Summensignal an Digitalpin 2 aktivieren
  attachInterrupt(0,su_sig,RISING);  

  // Servo Parameter zuweisen (hier: Jeti-Signale)
  sig_servo1.attach(pin_servo1, 750, 2250); 
  sig_servo2.attach(pin_servo2, 750, 2250);
  sig_servo3.attach(pin_servo3, 750, 2250);
  sig_servo4.attach(pin_servo4, 750, 2250);
  sig_servo5.attach(pin_servo5, 750, 2250);
  sig_servo6.attach(pin_servo6, 750, 2250);

  // Servos zunächst auf Mitte stellen (notwendig?)
  sig_servo1.writeMicroseconds(1500);
  sig_servo2.writeMicroseconds(1500);
  sig_servo3.writeMicroseconds(1500);
  sig_servo4.writeMicroseconds(1500);
  sig_servo5.writeMicroseconds(1500);
  sig_servo6.writeMicroseconds(1500);
  for (int i=0; i<16; i++) {
    l_su_tab[i] = 1500;
  }
  l_zeit = micros();  // erste Zeit für Zeitrechnung in der Interrupt-Routine

  // Serial.begin (9600); // nur für Tests: Seriellle Kommunikation starten

}

// Interrupt Status Routine (ISR) für Summensignal
void su_sig() {
  zeit = micros();        // aktuelle Zeit
  delta = zeit - l_zeit;  // Differenz zur letzten Zeit = aktuelle Signallänge
  l_zeit = zeit;          // neue Zeit = letzte Zeit
  if (delta > 3500) {     // dann wars der Start des Summensignals
    ind = -1;             // Tabellenindex zurücksetzen
  }
  else {
    ++ind;                // Index Summensignaltabelle erhöhen
    l_su_tab[ind] = su_tab[ind]; // letztes Signal sichern
    su_tab[ind] = delta;  // neues Signal in Summensignaltabelle speichern
  }

}

// Programmschleife
void loop() {
  if (su_tab[0] >= 750) { // bei erstem Durchlauf teilweise undefinierte Werte

    // Servos gem. Summensignal positionieren
    sig_diff = su_tab[kanal_servo1-1]-l_su_tab[kanal_servo1-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun) sig_servo1.writeMicroseconds(su_tab[(kanal_servo1-1)]);

    sig_diff = su_tab[kanal_servo2-1]-l_su_tab[kanal_servo2-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun)  sig_servo2.writeMicroseconds(su_tab[kanal_servo2-1]);

    sig_diff = su_tab[kanal_servo3-1]-l_su_tab[kanal_servo3-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun) sig_servo3.writeMicroseconds(su_tab[kanal_servo3-1]);

    sig_diff = su_tab[kanal_servo4-1]-l_su_tab[kanal_servo4-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun) sig_servo4.writeMicroseconds(su_tab[kanal_servo4-1]);

    sig_diff = su_tab[kanal_servo5-1]-l_su_tab[kanal_servo5-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun) sig_servo5.writeMicroseconds(su_tab[kanal_servo5-1]);

    sig_diff = su_tab[kanal_servo6-1]-l_su_tab[kanal_servo6-1];
    if (sig_diff < 0) sig_diff = sig_diff * -1;
    if (sig_diff > sig_nixtun) sig_servo6.writeMicroseconds(su_tab[kanal_servo6-1]);
    // testausgabe();
  }  
}

// Diese Routine ist nur für Testzwecke gedacht
/*
void testausgabe() {
  Serial.print ("servo1/k");
  Serial.print (kanal_servo1);
  Serial.print (":");
  Serial.println (su_tab[(kanal_servo1 - 1)]); 
  Serial.print ("servo2/k");
  Serial.print (kanal_servo2);
  Serial.print (":");
  Serial.println (su_tab[(kanal_servo2 - 1)]);
  Serial.print ("servo3/k");
  Serial.print (kanal_servo3);
  Serial.print (":");
  Serial.println (su_tab[(kanal_servo3 - 1)]);
  delay (1000);
}
*/
