#rem

Hardware: PICAXE 08M2

Alle Pin Funktionen (C.0 nur Ausgang, C.3 nur Eingang)
                       
                     +---v---+                           
                 Vdd |1     8| Vss                       
           RxD/I C.5 |2     7| C.0 O/TxD                 
   Touch/ADC/O/I C.4 |3     6| C.1 I/O/ADC/Touch         
               I C.3 |4     5| C.2 I/O/ADC/Touch/PWM/TUNE
                     +-------+                           
                       
Standard-Belegung mit Hall-Sensor											 
                     +---v---+                           
                 Vdd |1     8| Vss                       
           RxD/I C.5 |2     7| C.0 TxD, Piezzo-Summer              
 Empfaenger/Poti C.4 |3     6| C.1 Hall-Sensor   
          Taster C.3 |4     5| C.2 Servo
                     +-------+                           

Namenskonventionen (Praefixe)
l = label
pi = input pin
po = output pin
ps = pin state
t = bit var
b = byte var
w = word var
c = constant
r = RAM pointer
e = EEPROM pointer
sp = subprogram
tmr = timer related
msk = bit mask
flg = flag mask
#endrem

#rem
Versionshistorie

V1:	Erstversion, als Ausloeser fuer die Thermikbremse ist ein Schalter vorgesehen.

V2: Der Schalter zum Ausloesen der Thermikbremse wurde durch einen Hallsensor
		ersetzt. Dadurch musste die Pinbelegeung neu vergeben werden
		
V3:	Erweiterung zur Verwendung einer Fernsteuerung zum Ausloesen der Thermikbremse
		und zusaetzlicher Option, das Modell mit dem Seitenruder fernzusteuern.
		
V4: Erweiterung um die Moeglichkeit, den Summer via RC auszuloesen. Auszerdem wurden
		die Programmierroutinen erweitert und etwas geschmeidiger codiert.

V5: Nachdem die Sache mit dem servo und servopos nur sehr unbefriedigend funktioniert
		hat, letzter Versuch mit pulsout und eigenem Framerate Management. Wenn das auch
		nicht zufriedenstellend klappt, wird dieses Buch zugemacht und die Arduino Fibel
		aufgeschlagen.
		
V6: Hurra, es geht weiter: Die Routine fuer die Servoeinstellungen wurde so geaendert,
		dass nicht mehr zwangsweise alle Einstellungen geaendert werden muessen, sondern
		eine einzelner Parameter ausgewaehlt werden kann.
		
V7: Der verwendete Hallsensor wurde mit einem Pullup Widerstand versehen und kann damit
		statt mit ADCREAD mit Pinstatus abgefragt werden. Auszerdem sind die manchmal
		undefinierten Zust?nde nach Einbau in den Flieger behoben.
		
V8: Die Rountine fuers Programmieren der Zeit wurde in die Auswahl mittels Piepser
		integriert. Damit kann die Zeit nun auch programmiert werden, wenn eine
		Fernsteuerung verwendet wird.
		
V9: Fuer den RC-Modus wurde fuer die nicht vorgegebenen Signallaengen die Moeglichkeit
		geschaffen, das vom Sender kommende Servosignal zu invertieren, bevor es an
		das Servo weitergegeben wird. Hierzu wurde ein weiterer Parameter im EEPROM
		aufgenommen.
		
V10: 	Der RC-Betrieb wurde komplett geaendert. Der RC-Modus wurde in den Freiflug-
			Modus integriert. D.h. man kann zunaechst einen ganz normalen Freiflug
			inkl. Hochstart und Kurvensteuerung machen. Das Kommando wird erst
			dann uebernommen, wenn der Knueppel das erste Mal von der Mitte wegbewegt
			wird. 
			
V11:  Servoreverse wird jetzt auch beim Programmieren der Start- und Kurvenstellung
			beruecksichtigt. 
		
		

Ganz zu Anfang stehen alle programmsteuernden Variablen, damit man sie sich
nicht muehsam aus den ganzen Definitionen raussuchen muss.

Hinweis:

Wenn man einen Summer verwendet, der ein PWM-Signal benoetigt, dann muss als 
Outputpin C.2 verwendet werden, weil dies beim 08M2 so fix vorgegeben ist. 
Das Servo muss dann an C.0. Da C.0 auch fuer den Programm-Download benutzt wird,
muss das Servo zum Download unbedingt abgeklemmt werden. Deshalb ist die
Belegung Summer C.0 und Servo C.2 grundsaetzlich vorzuziehen.
#endrem



'steuernde Compiler-Variable

'**************************************************************************
'#define pwmsignal	'wenn aktiv Summer mit PWM-Signal, sonst nur ein und aus
	                   'auszerdem werden die Pins C.0 und C.2 vertauscht

#define hallsensor	'wenn aktiv Hallsensor an Pin C.1 und Poti an C.4
											'wenn inaktiv Oeffner an Pin C.4 und Poti/Empfaenger an C.1
											
#define wreeprom   'EEPROM mit Werten aus Programm versorgen. Wenn nicht 
										'gesetzt, dann bleibt EEPROM erhalten
'**************************************************************************
'zur Ermittlung des passenden PWMOUT-Kommandos PWMOUT Wizard des Editors verwenden!

'Programmsteuernde Konstanten

symbol c_kurz = 200					'kurze Pause fuer Summer
symbol c_lang = 2000				'lange Pause fuer Summer
symbol c_zeittakt = 30			'Zeittakt in Sekunden fuer Zeiteinstellung
symbol c_reserve = 5				'Wird auf berechnete Zeit noch aufaddiert

symbol c_pause_landung = 10 'Pause in Sekunden vor Einschalten Summer nach Landung
														'max. 65 Sekunden!!! Ansonsten gibt's einen Variablenueberlauf

'verwendete Pins
#ifdef pwmsignal then
	symbol po_servo = c.0			'Pin fuer Servoanschluss
	symbol po_summer = c.2		'Pin fuer Piezzo Summer bzw. LED im Test
#else
	symbol po_servo = c.2			'Pin fuer Servoanschluss
	symbol po_summer = c.0		'Pin fuer Piezzo Summer bzw. LED im Test
#endif

#ifdef hallsensor then
	symbol pi_poti = c.4			'Pin fuers Programmieren
	symbol pi_empf = c.4			'wird auch fuer Empfaengeranschluss genutzt
	symbol ps_hall = pinc.1		'Hallsensor an C.1
#else
	symbol pi_poti = c.1			'Pin fuers Programmieren
	symbol pi_empf = c.1			'wird auch fuer Empfaengeranschluss genutzt
	symbol ps_hall = pinc.4		'Hallsensor an C.1 / Oeffner
#endif

symbol c_magnet_da = 0
symbol c_magnet_weg = 1

'verwendete Pinstati
symbol ps_taster = pinc.3		'Taster fuer Programmierung


symbol c_angeschlossen = 1
symbol c_gedrueckt = 0

'*******************************************************
'Speichereessen fuer die steuernden Parameter im EPROM
'*******************************************************

symbol e_flugzeit = 0					'Flugzeit vom Ausklinken bis zum Ausloesen der Thermikbremse
symbol e_servo_neutral = 2		'Servostellung Geradeaus-Flug
symbol e_servo_kurve = 3			'Servostellung Kurvenflug
symbol e_servo_bremse = 4			'Servostellung Bremse ausloesen
symbol e_servo_piezzo = 5			'Servostellung Piezzo Summer ausloesen
symbol e_servo_reverse = 6		'Servoreverse bei RC-Betrieb (0 = nein, 1 = ja)

'EEPROM mit Standardwerten belegen

#ifdef wreeprom then
	eeprom e_flugzeit, (60,0)
	eeprom e_servo_neutral,(145)
	eeprom e_servo_kurve, (142)
	eeprom e_servo_bremse, (179)
	eeprom e_servo_piezzo, (111)
	eeprom e_servo_reverse, (1)		'0 = nein, 1 = ja
#endif


'fix verwendete Variablen
'die Bits von b0 werden fuer Flags verwendet
'fixe Bytevariablen

symbol flg_timer = bit0					'Betriebsart Timer
symbol flg_rcbremse = bit1			'Betriebsart RC-Bremse
symbol flg_kombi = bit2					'Kombiniertes Fliegen (frei + anschlieszend rc)
symbol flg_rcfliegen = bit3			'Betriebsart RC-Fliegen

symbol flg_brlinks = bit4				'Bremssignal < Servomitte
symbol flg_servo_reverse = bit5	'Servoreverse erforderlich
symbol flg_rc = bit6						'ab jetzt steuern

symbol b_neutral = b1
symbol b_kurve = b2
symbol b_bremse = b3
symbol b_progstat = b4	'Programmstatus zur Steuerung der Programmlogik
symbol b_hall = b5			'Variable fuer readadc Hallsensor
symbol b_piezzo = b6
symbol b_eeprom = b7

'Temporaere Bytevariablen
symbol b_temp1 = b7
symbol b_temp2 = b8

'fixe Wordvariablen

symbol w_flugzeit = w6
symbol w_empfsig = w7
symbol w_servopos = w8
symbol w_codezeit = w9
symbol w_servowait = w10
symbol w_pause = w11
symbol w_pulsout = w12



'temporaere Wordvariablen
symbol w_temp1 = w5
symbol w_temp2 = w13

'verwendete Konstanten

symbol true = 1		'fuer Flags
symbol false = 0	'fuer Flags
symbol c_framerate = 20
symbol c_freqmult = 8

'Programmstati
symbol c_anfaufgaben = 0 'Anfangsaufgaben
symbol c_progmod = 1	  'Programmiermodus
symbol c_bereit = 2			'neu eingeschaltet
symbol c_start = 3			'Startphase
symbol c_flug = 4				'Flugphase
symbol c_landung = 5		'Bremse gezogen



'Programmstart und Steuerroutine als Endlosschleife

l_start:
	setfreq m32
	gosub sp_lesen_eeprom			'Parameter aus dem EEPROM lesen
	w_codezeit = 4 / c_freqmult
	w_servopos = b_neutral	
	gosub sp_servopos
	b_progstat = c_anfaufgaben
	do
		'Unterprogramm zur jeweiligen Programmphase aufrufen
		'sertxd ("pst:",#b_progstat,cr,lf)
		on b_progstat gosub sp_anfaufgaben, sp_progmod_neu, sp_bereit, sp_start, sp_flug, sp_landung
		gosub sp_servopos
	loop
end

'Unterprogramm Servo positionieren
sp_servopos:
	w_pulsout = w_servopos * c_freqmult				'Anpassung an Taktfrequenz
	pulsout po_servo, w_pulsout								'Servoimpuls ausgeben
	s_w1 = c_framerate * 100									'Systemvariable weil UserVar alle belegt
	w_servowait = s_w1 - w_servopos						'Pause = Framerate - Servoimpuls
	'sertxd (#w_servowait, "/")
	w_servowait = w_servowait - w_codezeit		'Pause um Codezeit verringern
	if w_servowait <= s_w1 then								'Wenn Pause < Framrate
		w_servowait = w_servowait * c_freqmult	'Pause an Taktrequenz anpassen
		pauseus w_servowait											'Pause bis Framerate erreicht ist
	end if
return

'Unterprogramm Warten mit Servosignal (Ersetzt normale pause-Befehle)
sp_pause:
	w_codezeit = 1000 / c_freqmult
	for w_temp1 = 0 to w_pause step 20
		gosub sp_servopos
	next
return


'Unterprogramm Anfangsaufgaben

'Hier wird entschieden, in welchem Modus der Timer betrieben werden soll.
'Es gibt 4 Moeglichkeiten zu denen die entsprechenden Flags gesetzt werden.
'1. reiner Timermodus (flg_timer)
'2. nur Thermikbremse ueber RC (flg_rcbremse)
'3. Kombi-Modus (flg_kombi
'4. RC-Fliegen (flg_rcfliegen)

sp_anfaufgaben:
	b_progstat = c_progmod				'Setzen Programmiermodus
	if b_bremse < b_neutral then	'Bremssignal = kurzes Signal
		flg_brlinks = true					'Servoreverse gewuenscht (noch pruefen)
	endif
	w_pause = 1500
	gosub sp_pause								'warten auf Empfaenger-Bereitschaft
	pulsin pi_empf, 1, w_empfsig	'Empfaengersignal lesen (Timeout nach 0,6 Sekunden)
	w_empfsig = w_empfsig / c_freqmult
	'sertxd ("empfsig:",#w_empfsig,cr,lf)
	w_codezeit = 1000 / c_freqmult
	gosub sp_servopos	
	select w_empfsig
		case 0											'kein Empfaenger angeschlossen
			flg_timer = true					'nur Timerfunktion ohne rc
		case <= b_piezzo
			flg_kombi = true
		case b_bremse								'Signal fuer Bremse?
			flg_rcfliegen = true			'rc Fliegen gefordert
		case < b_bremse							'Signal kleiner Bremse?
			if flg_brlinks = true then		'Wenn ja, dann kleines Bremssignal?
				flg_rcfliegen = true		'wenn ja, rc Fliegen gefordert
			endif
		case > b_bremse								'Signal > Bremse?
			if flg_brlinks = false then	'groszes Bremssignal?
				flg_rcfliegen = true   		'wenn ja, rc Fliegen gefordert
			endif
	end select
	if flg_timer = false and flg_rcfliegen = false then	'wenn weder Timer noch rc Fliegen
		flg_rcbremse = true							'dann nur rc Bremse gefordert
	end if
	if flg_rcfliegen = true or flg_kombi = true then			'Fuers rc + Kobmi Fliegen muss 
		do															'das Anfagssignalzurueck genommen werden, damit bei
			w_pause = 500									'Kontrolluebernahme durch den Geber nicht gleich
			gosub sp_takten								'ein Vollausschlag erzeugt und ggf. die Bremse ausgeloest wird
			pulsin pi_empf, 1, w_empfsig	'Empfaengersignal lesen
			w_empfsig = w_empfsig / c_freqmult
			if w_empfsig > 130 and w_empfsig < 170 then
				w_pause = 250
				gosub sp_pause
				poke 80,word w_empfsig
				exit
			end if
		loop
	w_codezeit = 3000 / c_freqmult
	b_progstat = c_progmod
	end if
return

sp_progmod_neu:
	if ps_taster = c_angeschlossen then
		w_pause = c_kurz						'Tonlaenge festlegen
		for b_temp1 = 0 to 5
			for s_w2 = 0 to b_temp1		'Parameternummer signalisieren
				gosub sp_takten					'Summer betaetigen
			next		
				for s_w2 = 1 to 75			'Warten auf Tastendruck
					if ps_taster = c_gedrueckt then
						for s_w2 = 1 to 100	'Warten auf Tastenfreigabe
							w_codezeit = 1000/c_freqmult
							gosub sp_servopos
							if ps_taster = c_angeschlossen then	'Taster losgelassen
								gosub sp_progpar	'Parameter programmieren
								goto l_return_progmod	'nach einem Parameter ist Schluss
							end if
						next
					else
						w_codezeit = 1000/c_freqmult
						gosub sp_servopos
					end if
			next		
		next
	end if
l_return_progmod:
	gosub sp_lesen_eeprom					'eventuell ge?nderte Werte neu einlesen
	w_servopos = b_neutral				'Servo auf ev. neue Startstellung		
	b_temp1 = b0 and %00001111
	'ausgewaehlten Modus signalisieren
	lookup b_temp1, (0,1,2,0,0,0,3,0,4),b_temp2
	w_pause = 200						'Tonlaenge
	for b_temp1 = 1 to b_temp2
		gosub sp_takten
	next
	b_progstat = c_bereit		'jetzt kanns los gehen
return

sp_progpar:
	'Adresse des Parameters in b_eeprom ablegen
	lookup b_temp1,(e_servo_neutral,e_servo_kurve,e_flugzeit,e_servo_bremse,e_servo_piezzo,e_servo_reverse),b_eeprom
	if b_eeprom = e_flugzeit then
		gosub sp_zeitprog		'und auf gehts zur Zeitprogrammierung
	else
		if b_eeprom = e_servo_reverse then
			gosub sp_reverseprog
		else
			gosub sp_servoprog	'oder zur Programmierung der Servostellung
		endif
	endif
return


'Unterprogramm Zeit programmieren

sp_zeitprog:
	w_pause = 2000						'kurze Pause einlegen
	gosub sp_pause
	for b_temp1 = 1 to 10			'max 10 x 30 Sekunden
		w_pause = c_kurz 
		gosub sp_takten					'Ton ausgeben
		for b_temp2 = 1 to 50 	'ca. 1 Sek. auf Tastendruck warten
			if ps_taster = c_gedrueckt then
				goto zeit_gedrueckt			'goto, damit man nach dem lezten Blinken
														'nicht druecken muss!
			end if
			w_codezeit = 1000 / c_freqmult
			gosub sp_servopos			
		next	
	next	
zeit_gedrueckt:
	w_temp1 = b_temp1 * c_zeittakt + c_reserve 'neue Zeit berechnen und	
	write e_flugzeit, word w_temp1	'speichern
return

'Unterprogramm Servo Reverse programmieren

sp_reverseprog:
w_pause = 2000						'kurze Pause einlegen
	gosub sp_pause
	for b_temp1 = 0 to 1		
		w_pause = c_kurz 
		gosub sp_takten					'Ton ausgeben
		for b_temp2 = 1 to 50 	'ca. 1 Sek. auf Tastendruck warten
			if ps_taster = c_gedrueckt then
				goto reverse_gedrueckt			'goto, damit man nach dem lezten Blinken
														'nicht druecken muss!
			end if
			w_codezeit = 1000 / c_freqmult
			gosub sp_servopos			
		next	
	next	
reverse_gedrueckt:
	write e_servo_reverse, b_temp1	'speichern
return

'Unterprogramm Servowerte programmieren

sp_servoprog:
	'sertxd ("sp_wertmod:",cr,lf)
	do
		if flg_timer = true then
			readadc pi_poti, b_temp2						'Potistellung einlesen
			w_servopos = 10000/256*b_temp2/100+100 'Servostellung berechnen
			w_codezeit = 1500 / c_freqmult
		else
			pulsin pi_empf, 1, w_empfsig			'Empfaengersignal lesen
			w_empfsig = w_empfsig / c_freqmult
			w_servopos = w_empfsig						'Empfaengersignal uebernehmen
			if flg_servo_reverse = true then
				gosub sp_reverse
			end if
		endif
		gosub sp_servopos 									'Servo neu positionieren
		if ps_taster = c_gedrueckt then	'		'Wert speichern?
			b_temp2 = w_servopos
			write b_eeprom,b_temp2						'Wert in EEPROM schreiben
			exit															'do Schleife verlassen
		end if
	loop 
return

'Unterprogramm Timer ist bereit und wartet auf den Start

sp_bereit:
	w_servopos = b_neutral
	w_codezeit = 3200 / c_freqmult
	if ps_hall = c_magnet_da then 'Warten bis Magnet angesteckt ist
		b_progstat = c_start		'wenn ja, gehts mit dem naechsten Upro weiter
		time = 0								'Timer starten
	end if
return

'Unterprogramm fuer Startlauf
'Magnet muss mindestens 3 Sekunden anliegen, erst dann gehts
'in die Flugphase. Damit wird ein versehentliches kuerzeres Anlegen
'unterdrueckt.

sp_start:
	'sertxd ("start:", #b_hall,cr,lf)
	w_codezeit = 2400 / c_freqmult
	if ps_hall = c_magnet_weg then		'Magnet abgezogen
		gosub sp_zeitkorr
		'sertxd ("time:", #time, "/", #w_temp1, cr, lf)
		if w_temp1 < 3 then
				b_progstat = c_bereit	'wenn nicht mindestens 3 Sekunden auf ein dann da capo
		else
			b_progstat = c_flug
			w_servopos = b_kurve		'Kurve einleiten
			time = 0	'Timer zum Messen der Flugzeit nach dem Ausklinken starten
		end if
	end if
return
'Unterprogramm zur Zeitkorrektur in Abhaengigkeit von der Taktfrequenz
'Ergebnis wird in w_temp1 zurueckgeliefert
'Verstehen tu ich diese Logik nicht, ist aber definitiv so

sp_zeitkorr:
	b_temp1 = c_freqmult
	select b_temp1
		case 1			'4 MHz
		 	w_temp1 = time
		case 2			'8 MHz
		 	w_temp1 = time * c_freqmult
		case 4			'16 MHz
			w_temp1 = time
		case 8			'32 MHz						
			w_temp1 = time
	end select		
	'sertxd ("time:",#time,"/",#w_temp1,cr,lf)
return

'Unterprogramm fuer den Flug

sp_flug:
	'sertxd ("sp_flug",cr,lf)
	w_codezeit = 3000 / c_freqmult
	gosub sp_zeitkorr
	'sertxd (#time,"/",#w_temp1,cr,lf)
	if w_temp1 >= w_flugzeit  and flg_timer = true then		'Timerbetrieb und Zeit abgelaufen
		gosub sp_bremse 							'Bremse ziehen
	else
	  'sertxd (#w_temp1,"/")
		'w_temp1 = w_temp1 / 2
		'sertxd (#w_temp1,cr,lf)
		if w_temp1 >= w_flugzeit and flg_kombi = true then
			flg_kombi = false
			flg_rcbremse = false
			flg_rcfliegen = true
		end if
		if flg_timer = false then 
			gosub sp_bremscheck							'pruefen ob Bremse zu ziehen ist
		end if
		if b_progstat <> c_landung and flg_rc = true then	'Bremse wurde nicht gezogen
			if flg_servo_reverse = false then
        w_servopos = w_empfsig			'Empfaenger Signal uebernehmen
			else													'ansonsten Servosignal invertieren
				gosub sp_reverse
				w_codezeit = 16000 / c_freqmult
			endif
		end if
	end if
return
;Unterprogramm servo-reverse

sp_reverse:
	if w_empfsig < 150 then
		w_temp1 = 150 - w_empfsig
		w_servopos = 150 + w_temp1
	else
		w_temp1 = w_empfsig - 150
		w_servopos = 150 - w_temp1
	endif

return

'Unterprogramm pruefen RC-Kommando Bremse ausloesen

sp_bremscheck:
		'sertxd ("sp_bremscheck",cr,lf)
		'sertxd ("pulsin:")
		'w_codezeit = 4000 /c_freqmult
		'gosub sp_servopos
		pulsin pi_empf, 1, w_empfsig			'Empfaengersignal lesen
		w_codezeit = 1000/c_freqmult
		gosub sp_servopos
		w_empfsig = w_empfsig / c_freqmult
		peek 80, word w_temp2
		'sertxd(#w_empfsig,"/",#w_temp1,"/",#b_progstat,cr,lf)
		if flg_rcfliegen  = true and w_empfsig <> w_temp2 then
			flg_rc = true
		end if
		'sertxd (#w_empfsig,cr,lf)
		select w_empfsig									'Empfaengersignal pruefen
			case b_piezzo										'Piezzo Summer einschalten?					
				b_progstat = c_landung				'darf nur gemacht werden, wenn das Modell
																			'schon am Boden liegt, weil dann keine
																			'Fernsteuer Signale mehr uebertragen werden!!!!
				return															
			case b_bremse										'Signal = Bremssignal?
				gosub sp_bremse								'Bremse ziehen
			case < b_bremse									'Signal < Bremssignal
				if flg_brlinks = true then		'und kleines Bremssignal?
					gosub sp_bremse							'Bremse ziehen
				endif
			case > b_bremse									'Signal > Bremssignal 
				if flg_brlinks = false then		'und groszes Bremssignal?
					gosub sp_bremse							'Bremse ziehen
				endif
		end select
return

'unterprogramm Bremse ausloesen und nach 30 Sekunden auf Summer umschalten

sp_bremse:
	'sertxd ("sp_bremse",cr,lf)
	w_codezeit = 4000 / c_freqmult
	w_servopos = b_bremse
	gosub sp_servopos								'Bremse ziehen
	w_pause = 500										'1/2 Sek. warten
	gosub sp_pause
	w_servopos = b_neutral
	gosub sp_servopos								'nach 1 Sekunde Servo wieder auf Geradeausflug
																	'und dort bleibt's dann bis zum St. Nimmerlein
	w_pause = c_pause_landung*1000	'Pause vor Einschalten Summer
	gosub sp_pause
	b_progstat = c_landung					'und ab ab jetzt Summer betaetigen
	return

'Unterprogramm fuer die Landung
'Es laeuft in Endlosschleife bis zum Abschalten.
'Pausenzeiten koennen ueber die beiden Konstanten c_kurz und
'c_lang angepasst werden.

sp_landung:
	w_servopos = b_neutral					'Servo auf Neutralstellung
	w_pause = c_kurz								
	call sp_takten									'Summer aktivieren
	call sp_takten									'und nochmal
	w_pause = c_lang
	gosub sp_pause
return

'Unterprogramm Signalausgabe entweder pwmout oder digital
'Der Summer wird mit einem PWM-Signal von 2,7 KHz angesteuert.

sp_takten:
	#ifdef pwmsignal then
		pwmout pwmdiv64, po_summer, 92, 185	'Mit PWM-WIZARD erstellt
		gosub sp_pause
		pwmout po_summer, off
		gosub sp_pause
#else
		high po_summer
		gosub sp_pause
		low po_summer
		gosub sp_pause
	#endif
return

'Unterprogramm zum Auslesen der steuernden Parameter aus dem EEPROM
sp_lesen_eeprom:
	read e_flugzeit, word w_flugzeit
	read e_servo_neutral, b_neutral
	read e_servo_kurve, b_kurve
	read e_servo_bremse, b_bremse
	read e_servo_piezzo, b_piezzo
	read e_servo_reverse, b_temp1
	if b_temp1 = 0 then
		flg_servo_reverse = false
	else
		flg_servo_reverse = true
	endif
	'sertxd ("b_piezzoi",#b_piezzo,cr,lf)
return
	


