local appName = "rpmkolibri"
local anzpole
local teiler
local rpm
local logging=false
local intlogging		--fr persistente Speicherung
local logid = 0
local sens_id


-- Ausgabe ins Telemetriefenster
local function printrpm()
  lcd.drawNumber(5,0,rpm,FONT_BIG)
  lcd.drawText(60,0,"upm",FONT_BIG)
end

-- Anzahl Pole wurde gendert
local function anzpoleChanged(wert)
	anzpole=wert
	system.pSave("anzpole",wert) -- neuen Wert persistent speichern
	teiler = anzpole / 2
end

-- aktuellen Logwert versorgen
local function logwert(wert)
	wert = rpm
	return wert
end

-- Logging ja / nein wurde gendert
local function checkClicked (wert)
	logging = not wert
	form.setValue(loggingIndex,logging)
	if logging == true then
		system.pSave("logging",1)
		-- Abfrage auf 0 wegen u.a. Fehler, ohne Abfrage
		-- werden mehrere gleiche Logeintrge erzeugt
		if logid == 0 then
			-- logging aktivieren
			logid = system.registerLogVariable("Drehzahl","upm",logwert)
		end
	else
		system.pSave("logging",0)
		-- system.unregisterLogVariable(logid)
		-- fhrt leider auf der DC 16 V1 zu Fehler, in Emulation o.k.
		-- Deshalb Workaround mit nachfolgender Meldung
		system.messageBox("Wirkt erst nach Neuladen des Modells",4)
	end
end

-- Maske fr steuernde Parameter anlegen
local function initForm(subform)
	form.addRow(2)
	form.addLabel({label="Anzahl Motorpole:"})
	form.addIntbox(anzpole,2,28,12,0,2,anzpoleChanged)
	form.addRow(2)
	form.addLabel({label="Logging:",width=270})
	loggingIndex = form.addCheckbox(logging,checkClicked)
end

-- Einmalaufgaben nach Programmstart
local function init()
-- Sensortabelle lesen
	local sensors = system.getSensors()
	-- Sensortabelle abarbeiten, sensor.label = parameter 0
	for i,sensor in ipairs(sensors) do
		if (sensor.param == 0 and sensor.label == "KOLIBRI") then
			--ID sichern
			sens_id = sensor.id
			--print (sensor.label, sens_id)
		end
	end
	-- Menpunkt fr die App im Hauptmen anlegen
	system.registerForm(1,MENU_MAIN,appName,initForm)
	-- Anzahl Pole aus Modellspeicher lesen, falls nicht vorhanden Standard = 14
	anzpole=system.pLoad("anzpole",14)
	rpm = 0
	teiler = anzpole / 2
	-- Telemetriefenster anlegen
	system.registerTelemetry(1,"Drehzahl",0,printrpm)
	-- Logging 0 oder 1 aus Modellspeicher lesen, falls nicht vorhanden = 0
	intlogging=system.pLoad("logging",0)
	if intlogging == 0 then
		logging = false
	else
		logging = true
		-- logging aktivieren
		logid = system.registerLogVariable("Drehzahl","upm",logwert)
	end
	local sensor = system.getSensorByID (sens_id, 6)
	rpm = sensor.value / teiler	
end

-- Programmschleife
-- funktioniert so nur, wenn kein weiterer Sensor vorhanden,
-- erfordelichenfalls noch anpassen
local function loop()
	-- Sensortabelle lesen rpm = Parameter 6
	local sensor = system.getSensorByID (sens_id, 6)
	rpm = sensor.value / teiler
end



return {init=init, loop=loop, author="ich", version="7", name=appName}

