/*
 Dieses Programm realisiert die Ansteuerung eines Piloten mit zwei Servos. Servo 1 
 dreht den Kopf zur Seite und Servo 2 bewegt einen Arm zum Winken. Beides wird durch
 einen Taster am Sender ausgelöst. Wird dieser kurz gedrückt, dann dreht der Pilot
 den Kopf zur Seite und winkt so lange, bis der Taster erneut gedrückt wird. Nach
 Beenden des Winkens wird der Kopf wieder auf neutral gestellt. 
 

 Versionsnachweis:

 V1: Erste Version
 V2: Umstellung von Ein-Aus-Schalter auf Taster
 V3: langsames Anfahren der Ausgangs- und Endpositionen sowohl beim 
     Ein- als auch Ausschalten des Winkens. 
*/


// Pin-Belegung Eingangssignal vom Empfänger (Digital Pin)
int pin_empf = 2;

// Pin-Belegung für Servos Kopf und Arm (Digital Pins)
int pin_kopf = 3; 
int pin_arm = 4;

// Pin-Belegung interne LED (Digital Pin, nur zur Zustandsanzeige)
int pin_led = 13;

// Servosignale für Kopf und Armsteuerung 
// Bitte den konkreten Gegebenheiten anpassen (z.B. 1000 = 1,000 mSek)

int kopf_neutral = 1500;  //Pilot schaut geradeaus
int kopf_seite = 970;  //Pilot schaut zu einer Seite
int arm_neutral = 1275;  //Arm in Grundhaltung

// ************************************************************
// Achtung: arm_links muss kleiner sein als arm_rechts !!!!!  *
// ************************************************************

int arm_links = 1275;  //Arm links oder unten
int arm_rechts = 1900; //Arm rechts oder oben
int arm_akt;           //Armposition nach Abschalten des Winkens 
int arm_vz = 10;       //Verzögerung für Armbewegung darf nicht Null sein!

// Empfängersignal für Sequenzauslösung
// Bitte den konkreten Gegebenheiten anpassn

int empf_taster_ein = 1600; // >= Taster ein, < Taster aus
int empf_signal;            // vom Empfänger kommendes Signal
boolean flip_flop;          // zur Programmsteuerung
boolean kopf_gedreht;       // wahr, wenn Pilot zur Seite schaut  

#include <Servo.h> // Bibliothek für Servoansteuerung

// Einrichten der Servoinstanzen
Servo servo_kopf;
Servo servo_arm;

// Einmalaufgaben nach dem Einschalten des Empfängers

void setup() {
  // Ein- Ausgabepins festlegen
  pinMode (pin_empf,INPUT); 
  pinMode(pin_led,OUTPUT);

  //Beginn Serielle Kommunikation
  
  //Serial.begin(9600); // Nur für Testzwecke aktivieren!!!
      
  // Aktivieren und Ansteuern der Servos
  servo_kopf.attach(pin_kopf,1000,2000);
  servo_kopf.writeMicroseconds(kopf_neutral);
  servo_arm.attach(pin_arm,1000,2000);
  servo_arm.writeMicroseconds(arm_neutral);

  digitalWrite(pin_led, LOW); //Status LED auf aus
  // Serial.println("Programmstart");
  flip_flop = false;
  kopf_gedreht = false;
 } //end setup

// Steuerschleife
void loop() {

  //Serial.println(flip_flop);
  if(flip_flop == true){          // Taster zum Einschalten gedrückt
    if (kopf_gedreht == false){   // Kopf noch nicht gedreht     
      kopf_drehen();
      kopf_gedreht = true;        // Status auf Kopf bereits gedreht
    }
    winken ();    // Arm bewegen  
  }
  else {
    empf_lesen(); // Empfängersignal einlesen
  }
} //end loop

// Empfängersignal einlesen
void empf_lesen(){
  empf_signal = pulseIn(pin_empf,HIGH); // Empfängersignal lesen
  if(empf_signal >= empf_taster_ein){   // Taster ist gedrückt
    while (empf_signal >= empf_taster_ein){ // Taster "entprellen"
      empf_signal = pulseIn(pin_empf,HIGH);
      } //end while
    if(flip_flop == true){  // Taster zum Ausschalten gedrückt
      flip_flop = false;    // Status Action zurücksetzen
      // kopf_zurueck();
      kopf_gedreht = false; // Status Kopf gedreht zurücksetzen
    }
    else  // Taster zum Einschalten gedrückt
    {
      flip_flop = true;   // Status Action settzen
    } // end if
  } // end if
} // end void

// Kopf drehen
// je nach Parameter entweder Signal bis Kopfstellung vergrößern oder verkleinern 
void kopf_drehen() {
  if (kopf_seite > kopf_neutral){
    for (int i=kopf_neutral; i<=kopf_seite; i=i+20){
      servo_kopf.writeMicroseconds(i);
      delay (arm_vz*2);
    } // end for
  }
  else
  {
    for (int i=kopf_neutral; i>=kopf_seite; i=i-20){
      servo_kopf.writeMicroseconds(i);
      delay (arm_vz*2);
    } // end for
  } // end if
} // end void

// Kopf zurückdrehen
// je nach Parameter entweder Signal bis Kopfstellung vergrößern oder verkleinern 
void kopf_zurueck() {
  if (kopf_neutral > kopf_seite){
    for (int i=kopf_seite; i<=kopf_neutral; i=i+20){
      servo_kopf.writeMicroseconds(i);
      delay (arm_vz*2);   // Kopfdrehen langsamer als Winken
    } // end for
  }
  else
  {
    for (int i=kopf_seite; i>=kopf_neutral; i=i-20){
      servo_kopf.writeMicroseconds(i);
      delay (arm_vz*2);
    } // end for
  } // end if
} // end void

// Winken ausführen bzw. wenn gefordert abbrechen und Arm zurücksetzen
void winken() {
  digitalWrite(pin_led, HIGH);  //Status LED einschalten
    for (int i1=arm_neutral; i1 <= arm_rechts; i1 = i1+20){
      servo_arm.writeMicroseconds(i1);  //Arm nach rechts bewegen
      empf_lesen();
      if (flip_flop == false){     //Taster zum Abbrechen gedrückt
        arm_akt = i1;
        goto abbruch;
      } // end if
      delay(arm_vz);  //Bewegung verzögern
    } //end for 
    for (int i1=arm_rechts; i1 >= arm_links; i1 = i1-20){
      servo_arm.writeMicroseconds(i1);  //Arm nach links bewegen
      empf_lesen();
      if(flip_flop == false){
        arm_akt = i1;
        goto abbruch;
      }
     delay(arm_vz);
    } //end for
    for (int i1=arm_links; i1 <= arm_neutral; i1 = i1+20){
      servo_arm.writeMicroseconds(i1);
      empf_lesen();
      if (flip_flop == false){
        arm_akt = i1;
        goto abbruch;
      }
      delay (arm_vz);
    } // end for
    goto ende_winken; 
  abbruch:
    if (arm_akt>arm_neutral){
      for (int i1=arm_akt; i1>=arm_neutral; i1 = i1-20){
        servo_arm.writeMicroseconds(i1);
        delay (arm_vz*2);
      } // end for
    } // end if
    if (arm_akt<arm_neutral){
      for (int i1=arm_akt; i1 <= arm_neutral; i1 = i1 + 20){
        servo_arm.writeMicroseconds(i1);
        delay (arm_vz*2);
      }
    }
    kopf_zurueck();
ende_winken:
  arm_akt = arm_neutral;   
} //end void
