// Steuerung Entlader durch PWM-Signal welches KFZ-Lampen ansteuert; Datenstand: 13.07.2023 
// Verwendung Arduino Pro Mini 5V /16 MHz

#include <LiquidCrystal.h>      // Einbinden der Bibliothek "LiquidCristal"
LiquidCrystal lcd(9,8,7,6,5,4);   // Definition der Pin-Belegung der LCD Anzeige  

// Pinning
  int usteuer = A0;     // Bitwert 0 - 1023 aus Analogeingang0
  int led_1 = 10;       // Ausgang Digital 10 PWM anschließen => FET steuern
  int led_start = 13;   // LED Start und LED Stop an D13 anschließen
  int power = 11;       // Ausgang D11 steuert Relais an für Power ON
  int strom_bit_2 = A2 ;  // Strom Endstufe 2 als Bit auf Analogeingang A2in
  int zell_min_bit = A1 ; // Mindestspannung je Zelle, über Poti einstellbar und an A5 ausgeben
  int zelle_1 = A4;   // Bitwert von Zelle 1 an A4
  int zelle_2 = A5;   // Bitwert von Zelle 2 an A5
  int zelle_3 = A6;   // Bitwert von Zelle 3 an A6
  int zelle_4 = A7;   // Bitwert von Zelle 4 an A7
  int akku_ges = A3;  // Bitwert von Gesamtspannung an Analogeingang A3

// values
  int steuer ;       // Bitwert 0 - 255 zur Ansteuerung von LED an D3
  unsigned long akkuspannung ;     // Akkuspannung als Bit
  unsigned long spannung ;     // Akkuspannung als Volt (Gesamtspannung)
  unsigned long akkustrom_2 ;     // Akkustrom 2 als Bit
  unsigned long strom_2 ;     // Strom Endstufe 1
  unsigned long leistung ;     // leistung = spannung * Strom
  int zell_min_map ;     // gemappte Spannung im Wertebereich 250 bis 400
  unsigned long zell_min ;     // Mindestspannung je Zelle in Volt
  int modus_el = 2 ; // Start
  int result = 1 ;            // Variable result definieren; Wert für Fallunterscheidung LCD-Steuerung
  int limit = 0 ;   // variable zur Stromsteuerung in 4 Stufen
  float capa ;          // Kapazität in mAh als Variable definieren für Einzelmessung in einer Sekunde
  
// Zeitvariablen
  unsigned long zeitvorgabe ;          // 1 Sekunde Countdown als gerinster voreingestellter Zyklus
  unsigned long startzeitpunkt = 0 ;   // Definiton Startzeitpunkt
  unsigned long zeitaktuell = 0 ;      // Definition der Variablen Zeitaktuell
  unsigned long zeitendpunkt = 0 ;     // Definition Zeitendpunkt 
  unsigned long restzeit = 0 ;         // Definition Restzeit
  int sekunde = 0 ;
  int minute = 0 ;
  int sekunde_h = 0 ;
  int minute_h = 0 ;
  int sekunde_ab = 600 ;
  int xzelle ;                // Anzahl der angeschlossenen Zellen
  int uzelle_1 ;   // Bitwert von Zelle 1
  int uzelle_2 ;   // Bitwert von Zelle 2
  int uzelle_3 ;   // Bitwert von Zelle 3
  int uzelle_4 ;   // Bitwert von Zelle 4
  int uakku_ges ; 

// Variablen für Spannungen
  unsigned long szelle_1 ;    // Spannung in Volt von Zelle 1
  unsigned long szelle_2 ;    // Spannung in Volt von Zelle 2
  unsigned long szelle_3 ;    // Spannung in Volt von Zelle 3
  unsigned long szelle_4 ;    // Spannung in Volt von Zelle 4
  unsigned long summe_u  ;    // Gesamtspannung aller Zellen in Volt
  unsigned long min_1_2 ;     // minimale Spannung der Zellen 1 und 2
  unsigned long min_3_4 ;     // minimale Spannung der Zellen 3 und 4
  unsigned long min_1_4 ;     // minimale Spannung der Zellen 1 bis 4
  unsigned long max_1_2 ;     // maximale Spannung der Zellen 1 und 2
  unsigned long max_3_4 ;     // maximale Spannung der Zellen 3 und 4
  unsigned long max_u ;       // maximale Spannung der 6 Zellen
  unsigned long min_u ;       // minimale Spannung der 6 Zellen
  unsigned long akkuspannung_ges ;  // Akkuspannung gesamt in V; gemessen an A3 und entsprechend umgerechnet

// Korrekturfaktoren definieren zur Kalibrierung der Analogeingänge
  unsigned long korr_A2 =1.0000 ; // Korrekturfaktor Strom
  unsigned long korr_A3 =1.0000 ; // Korrekturfaktor Gesamtspannnung
  unsigned long korr_A4 =1.0000 ; // Korrekturfaktor Zelle1
  unsigned long korr_A5 =1.0000 ; // Korrekturfaktor Zelle2
  unsigned long korr_A6 =1.0000 ; // Korrekturfaktor Zelle3
  unsigned long korr_A7 =1.0000 ; // Korrekturfaktor Zelle4

void setup() 
{ 
  lcd.begin(16,2) ;          // LCD-Anzeige mit 16 Zeichen je Zeile und 2 Zeilen definieren
  lcd.clear() ;                  // lcd leeren  
  lcd.setCursor(0,0) ;           // setze Cursor auf das 1. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
  lcd.print("PWM-Stromsenke") ;   //ausgeben eines festen Textes in "Hochkomma"
  lcd.setCursor(0,1) ;           // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
  lcd.print("VTH-Verlag 2023") ;   //ausgeben eines festen Textes in "Hochkomma"   
  
  pinMode(led_1,OUTPUT) ;
  pinMode(led_start,OUTPUT) ;
//  pinMode(led_stop,OUTPUT) ;
  pinMode(power,OUTPUT) ;

  attachInterrupt(0, modus_LCD, FALLING ); // wenn DO (Pin2) Low ist, dann führe void "modus_LCD" aus
  attachInterrupt(1, start, FALLING ); // wenn D1 (Pin3) Low ist, dann führe void "start" aus
  
  delay(1000) ;                  // 1000 ms warten   
   
  startzeitpunkt = millis() / 1000 ; // startzeitpunkt erstmalig setzen damit dieser definiert wird; ! millis laufen schon seit Einschalten des Arduino!! 
  zeitvorgabe = 1 ;                  // Zeitvorgabe auf eine Sekunde (1) definieren
  
  digitalWrite(led_start , HIGH);  
  tone(12, 2000 , 400);         // Ton an D12 mit 2000 Hz für 400 ms ausgeben 
//  digitalWrite(led_stop , LOW);  
}

void loop() 
{
  uzelle_1 = analogRead(zelle_1);             // Auslesen Zelle 1 an A4
  uzelle_2 = analogRead(zelle_2);             // Auslesen Zelle 2 an A5
  uzelle_3 = analogRead(zelle_3);             // Auslesen Zelle 3 an A6
  uzelle_4 = analogRead(zelle_4);             // Auslesen Zelle 4 an A7
  uakku_ges = analogRead(akku_ges);           // Auslesen Zelle 4 an A7
      
  float szelle_1 = (uzelle_1 / (190.35 * 1.00811) * korr_A4) ;      // Wert für Zelle 1 in Spannungswert umrechnen 
  float szelle_2 = (uzelle_2 / (208.88 * 1.00811) * korr_A5) ;      // Wert für Zelle 2 in Spannungswert umrechnen 
  float szelle_3 = (uzelle_3 / (202.0077 * 1.00811) * korr_A6) ;      // Wert für Zelle 3 in Spannungswert umrechnen 
  float szelle_4 = (uzelle_4 / (216.609  * 1.00811) * korr_A7) ;      // Wert für Zelle 4 in Spannungswert umrechnen
  float akkuspannung_ges = (uakku_ges / (38.81 * 1.00000) * korr_A3) ;      // Wert für Akkugesamtspannung (A3) in Spannungswert umrechnen
  
  float summe_u = (szelle_1 + szelle_2 + szelle_3 + szelle_4 ) ; //  / Gesamtspannung aller 4 Zellen berechnen
   
  if (szelle_2 < 1.00) (szelle_2 = 9.00 ) ;
  float min_1_2 = min (szelle_1 , szelle_2) ;  // Ermittle Minimum aus Zelle 1 und 2
  
  if (szelle_3 < 1.00) (szelle_3 = 9.00 ) ;
  if (szelle_4 < 1.00) (szelle_4 = 9.00 ) ;
  float min_3_4 = min (szelle_3 , szelle_4) ;  // Ermittle Minimum aus Zelle 3 und 4
  
  float min_1_4= min (min_1_2 , min_3_4) ;  // Ermittle Minimum aus Zelle 1 bis 4
  float max_1_2 = max (szelle_1 , szelle_2) ;  // Ermittle Maximum aus Zelle 1 und 2
  
// Bestimmung der Anzahl angeschlossener Zellen (Anzahl zwischen 1 und 6)
   if (szelle_1 > 2.50) (xzelle = 1) ;    // es sind 1 Zellen angeschlossen
   if (szelle_2 < 9.00) (xzelle = 2) ;    // es sind 2 Zellen angeschlossen
   if (szelle_3 < 9.00) (xzelle = 3) ;    // es sind 3 Zellen angeschlossen
   if (szelle_4 < 9.00) (xzelle = 4) ;    // es sind 4 Zellen angeschlossen
   if (akkuspannung_ges > 16.80) (xzelle = 5) ;    // es sind 5 Zellen angeschlossen
   if (akkuspannung_ges > 21.00) (xzelle = 6) ;    // es sind 6 Zellen angeschlossen
    
   steuer = analogRead(usteuer);           // Auslesen Analogeingang A0 als 8 Bit 0 - 1023
   steuer = map(steuer, 0, 1023, 0, 255) ; // skaliere Steuersignal 0 - 1023 Bit auf Werte von auf 0 - 255

   akkustrom_2 = analogRead(strom_bit_2) ;        // einlesen Analogeingang A2 (Strom Endstufe 2)
   float strom_2 = ((akkustrom_2 / 52.0735) * korr_A2 + 0.001) ; // Umrechnung von Digitalwert auf Strom
    
   zell_min = analogRead(zell_min_bit) ;   // einlesen Analogeingang A2 (Akkuspannung)
   zell_min_map = map(zell_min, 0, 1023, 280, 390) ; // skaliere zellmin 0 - 1023 Bit auf Werte von auf 280 - 390 und teile das Ergebnis durch 100
   float zell_min = zell_min_map / 100.0000  ;               // Wert von zell_min auf Wertebereich 2,50 V bis 3,90 V bringen
 
   float leistung = (strom_2 * akkuspannung_ges) / 1.0000 ; // Leistung = Strom * (summe Einzelspnnungen)
                                              
   zeitaktuell = millis() / 1000 ;              // zeitaktuell wird in jedem Durchlauf mit der Funktion millis() neu zugewiesen
   zeitendpunkt = startzeitpunkt + zeitvorgabe ;  // Berechnung des Zeitendpunktes zu dem der Timer abgelaufen ist
   restzeit = zeitendpunkt - zeitaktuell ;        // Berechnung der Restzeit bis zum Ende der Timerzeit  

    if ( restzeit <=0 and modus_el == 2 )        // //////////////////////////// Wenn Restlaufzeit abgelaufen und modus = Entladen dann Bedingung ausführen
{
     sekunde = sekunde + 1 ;  // Berechnung der verbleibenden Sekunden (kleiner 60) anhand der Restzeit
     capa = capa + float ((zeitvorgabe * strom_2 * 1000.0) / (3600.0 * 3.21)) ;      // Addition der Kapazitätsermittlung je Zeitvorgabe (1 Sekunde) und Umrechung A in mA und Sekunde in Stunde 
     startzeitpunkt = millis() / 1000 ; // startzeitpunkt neu setzen damit ein nächster (sinnvoller) countdown erfolgen kann
} 
    else
{      
      sekunde = sekunde ;       // Sekunde wird nicht erhöht
      capa = capa + float ((zeitvorgabe * strom_2 * 1000.0) / (3600.0 * 3.21)) ;  // capa wird auch neu berechnet wenn Endstufe aus => Eigenverbrauch 0,1 A
      startzeitpunkt = millis() / 1000 ; // startzeitpunkt neu setzen damit ein nächster (sinnvoller) countdown erfolgen kann  
}        

if (sekunde >59)                     // wenn die 59. Sekunde überschritten ist wird Minute um eins erhöhen und Sekunde auf 0 zurückgestellt
{
    minute = minute +1 ;                // Minute um 1 nach oben zählen
    sekunde = 0 ;                        // Sekunde auf 0 zurücksetzen
    tone(12, 1500 , 400);         // Ton an D12 mit 1500 Hz für 400 ms ausgeben  
}    

// Abschaltkriterien festlegen um den Entladevorgang zu stoppen
    if (min_1_4 < zell_min)        // Wenn Mindestspannung unterschritten dann ....
{
       digitalWrite(led_start , LOW);  // LED Start aus und LED Stop an
       tone(12, 3000 , 400);         // Ton an D12 mit 2000 Hz für 400 ms ausgeben  
       steuer = 0 ;                    // Endstufe abschalten, Ausgang D10 wird mit 0 Bit angesteuert
       modus_el = 1 ;                  // Status =1 (Stop)
       result = 1;                    // LCD-Anzeige auf Seite 1 umschalten 
} 

// Schutz der Endstufe vor zu hohem Impulsstrom > 11 A
    if (strom_2 > 11.0 )        // Wenn Strom von 11 A überschritten dann Endstufe abschalten
{
       digitalWrite(led_start , LOW);  // LED Start aus
       tone(12, 2000 , 400);         // Ton an D12 mit 2000 Hz für 400 ms ausgeben   
 //      digitalWrite(led_stop , HIGH);  // LED Stop an
       steuer = 0 ;                    // Endstufe abschalten, Ausgang D10 wird mit 0 Bit angesteuert
       modus_el = 1 ;                  // Status =1 (Stop) 
} 

    if (modus_el == 2 )                // Solange Modus_el = 2 (Start) Endstufe ansteuern mit PWM-Signal
  {
    analogWrite(led_1, steuer);        // LED_1 lässt sich über PWM 0 - 255 steuern
  }
    else
  {
       digitalWrite(led_1, LOW);      // Endstufe bleibt aus
  }

//   wenn Endstufe 10 Minuten auf Stop, dann power auf 0 stellen => Relais fällt ab und alles wird stromlos
    if (modus_el == 1 )
  {
    sekunde_ab = sekunde_ab - 1 ;     // sekunde_ab beginnt bei 600 Sekunden, Countdown bis auf 0
//  Prozessor schaltet sich selbst ab nach 600 Sekunden Countdown   
    if (sekunde_ab <= 0 )   { digitalWrite(power, LOW); }      //  Ausgang D10 auf LOW setzen
    delay (685) ;                     // Pause von 685 ms
  }
// Bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 550)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 500)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 450)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 400)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 350)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 300)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 250)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 200)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 150)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab == 100)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab ==  50)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 50 Sekunden ein Beep
    if (sekunde_ab ==  10)   { tone(12, 2000 , 400) ; }      //  bei Countdown alle 30 Sekunden ein Beep

    digitalWrite(power, HIGH) ;              //  Ausgang D10 auf HIGH setzen

switch (result)                     // Schalter für Variable result
{ 

 case 1 :   // Startseite Umin, Anzahl Zellen; Sekunden bis Abschaltung
  lcd.clear() ;                      // lcd leeren
  lcd.setCursor(0,0) ;            // setze Cursor auf das 1. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
  lcd.print("Vmin Abschaltung") ;          // Spannung Zelle 1 anzeigen
  lcd.setCursor(0,1) ;            // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.print(zell_min) ;          // ausgeben zell min Mindestspannung je Zelle 
  lcd.setCursor(5,1) ;            // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.print(xzelle) ;               // ausgeben erkannte Anzahl von Lipo Zellene
  lcd.setCursor(7,1) ;              //
  lcd.print("Zell") ;               // 
  lcd.setCursor(12,1) ;            // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.print(sekunde_ab) ;          // ausgeben der verbleibenden Sekunden bis zur Abschaltung Entlader (spannungslos)  
    delay(300) ;
 break ; 
  
 case 2 :      // Seite 2  Einzelzellenanzeige Zellen 1 bis 4
  lcd.clear() ;                      // lcd leeren
  lcd.setCursor(0,0) ;            // setze Cursor auf das 1. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
  lcd.print(szelle_1 , 2) ;          // Spannung Zelle 1 anzeigen 
  lcd.setCursor(5,0) ;             // setze Cursor auf das 6. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.print(szelle_2 , 2) ;          // Spannung Zelle 2 anzeigen   
  lcd.setCursor(10,0) ;            // setze Cursor auf das 11. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)  
  lcd.print(szelle_3 , 2) ;          // Spannung Zelle 3 anzeigen
  lcd.setCursor(15,0) ; 
  lcd.print("V") ; 
  lcd.setCursor(0,1) ;            // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)   
  lcd.print(szelle_4 , 2) ;          // Spannung Zelle 4 anzeigen 
  lcd.setCursor(5,1) ;              // setze Cursor auf das 6. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.setCursor(15,1) ;             // auf 16. Zeichen in der 2. Zeile stellen und die Variable modus "V" ausgeben (nächste Zeile 
  lcd.print("V") ;                // Zeichen V ausgeben
    delay(300) ;
break ;  


 case 3 :   // Seite 3   Spannung / Strom / Zeit / Kapazität
   lcd.clear() ;                      // lcd leeren
   lcd.setCursor(0,0) ;            // setze Cursor auf das 1. Zeichen in der ersten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
   lcd.print(akkuspannung_ges) ;       // ausgeben Spannung gesamt in Volt; Wert ermittelt über A3
   lcd.setCursor(6,0) ; 
   lcd.print("V") ;                // Testweise den Wert für "modus" ausgeben
   lcd.setCursor(8,0) ; 
   lcd.print(strom_2, 2) ;       // ausgeben Strom als Ampere 
   lcd.setCursor(14,0) ; 
   lcd.print("A") ;                // Testweise den Wert für "modus" ausgeben
   lcd.setCursor(0,1) ;           // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
   lcd.print(minute) ;       // ausgeben Strom als Bitwert
   lcd.setCursor(3,1) ;           // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)  
   lcd.print(":") ;  
   lcd.setCursor(4,1) ;           // setze Cursor auf das 4. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
   lcd.print(sekunde) ;       // ausgeben Strom als Bitwert
   lcd.setCursor(8,1) ;           // setze Cursor auf das 7. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1)         
   lcd.print(int (capa)) ;            // ausgeben Ergebnis capa in mAh
   lcd.setCursor(13,1) ;          
   lcd.print("mAh") ; 
   delay(300) ;
 break ; 

 case 4 :   // Seite 4       Unterspannung / Zeit / Kapazität / Leistung
  lcd.clear() ;                      // lcd leeren
  lcd.setCursor(0,0) ;                  
  lcd.print( min_1_4 , 2 ) ; // Spannung minimum Zellen 1 bis 4        
  lcd.setCursor(0,1) ;   
  lcd.print(zell_min) ;       // ausgeben Strom als Bitwert 
  lcd.setCursor(8,0) ;  
  lcd.print(int (capa)) ;            // ausgeben Ergebnis capa in mAh
  lcd.setCursor(13,0) ;          
  lcd.print("mAh") ; 
  lcd.setCursor(5,1) ;  
  lcd.print("V") ; 
  lcd.setCursor(8,1) ;  
  lcd.print(leistung , 0) ;       // Ausgeben der errechneten Leistung in Watt
  lcd.setCursor(12,1) ;  
  lcd.print("Watt") ;
  delay(300) ;
 break ; 

 case 5 :   // Seite 5      Gesamtspannung / Min-Spannung / Max-Spannung
  lcd.clear() ;                    // lcd leeren
  lcd.setCursor(0,0) ;             // setze Cursor auf das 1. Zeichen in der zweiten Zeile (Zaehlung beginnt bei 0 und nicht bei 1) 
  lcd.print("Z1-Z4  Min  Max") ;   // ausgeben Gesamtspannung und Minwert / Maxwert
  lcd.setCursor(0,1) ;             // auf 16. Zeichen in der 2. Zeile stellen und die Variable modus "V" ausgeben (nächste Zeile 
  lcd.print(summe_u , 2) ;         // Summe aller Einzelspannungen ausgeben
  lcd.setCursor(7,1) ;             // Cursor auf 8. Zeichen in Zeile 2
  lcd.print( min_1_4 , 2) ;        // minimale Spannung der Zellen 1 bis 4 anzeigen
  lcd.setCursor(12,1) ;             // Cursor auf 12. Zeichen in Zeile 2
  lcd.print( max_1_2 , 2) ;        // maximale Spannung der Zellen 1 und 2 anzeigen
  delay(300) ;
 break ; 

}
} 

void modus_LCD()
{
  result = result + 1 ;              // result wird vom Startwert =1 immer um 1 erhöht
  tone(12, 2000 , 400);         // Ton an D12 mit 2000 Hz für 400 ms ausgeben  
  if (result > 5)  (result = 1) ;    // wenn result > 4 wird result auf 1 zurückgesetzt
}

void start()
{
  modus_el = 2 ;   // modus_el = 2 (Start)
  digitalWrite(led_start , HIGH );
  tone(12, 2000 , 400);         // Ton an D12 mit 2000 Hz für 400 ms ausgeben   
 // digitalWrite(led_stop , LOW); 
  sekunde_ab = 600 ; 
}

